<?php
// معلومات الأقسام
$departments = array(
    array(
        'totalRequests' => 2,
        'requestTimes' => array(20, 20),
        'requestQuality' => array(5, 5)
    ),
    array(
        'totalRequests' => 3,
        'requestTimes' => array(15, 18, 12),
        'requestQuality' => array(4, 3, 5)
    ),
    // يمكنك إضافة معلومات أقسام إضافية هنا
);

// حساب التقييم النهائي لكل قسم
foreach ($departments as $department) {
    $totalRequests = $department['totalRequests'];
    $requestTimes = $department['requestTimes'];
    $requestQuality = $department['requestQuality'];

    // حساب التقييم بناءً على الوقت المستغرق
    $rating = 100;
    foreach ($requestTimes as $time) {
        if ($time > 15) {
            $rating -= 2; // قم بتعديل القيمة حسب تفضيلاتك
        }
    }

    // حساب التقييم بناءً على جودة الطلبات
    $totalQuality = array_sum($requestQuality);
    $averageQuality = $totalQuality / $totalRequests;
    $ratingQuality = ($averageQuality / 5) * 100;

    // حساب التقييم النهائي
    $finalRating = ($rating + $ratingQuality) / 2;

    echo "تم تقييم أداء القسم بنسبة: " . $finalRating . "%<br>";
}
?>