<?php 
require 'vendor/autoload.php';

use Phpml\Classification\MLPClassifier;
use Phpml\FeatureExtraction\StopWords\English;
use Phpml\FeatureExtraction\TfIdfTransformer;
use Phpml\Preprocessing\Tokenizer;
use Phpml\Tokenization\WhitespaceTokenizer;

// Connect to the MySQL database
$servername = "localhost";
$username = "marsalog_mahran";
$password = "gX-;hjZN-B*u";
$database = "marsalog_shipping_clearance_db";

$conn = new mysqli($servername, $username, $password, $database);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Load the training data from the database
$sql = "SELECT details, request_stat FROM hr_request_tbl";
$result = $conn->query($sql);

$samples = [];
$labels = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $samples[] = $row['details'];
        $labels[] = $row['request_stat'];
    }
}

// Preprocess the text features using tokenization and TF-IDF transformation
$tokenizer = new Tokenizer(new WhitespaceTokenizer());
$tfIdfTransformer = new TfIdfTransformer($tokenizer, new English());
$samples = $tfIdfTransformer->transform($samples);

// Create and train a neural network classifier
$classifier = new MLPClassifier(2, [10], ['refuse', 'accept']); // Adjust input features, hidden layers, and output labels as needed
$classifier->train($samples, $labels);

// Process new vacation requests from the database
$newRequestSql = "SELECT details FROM hr_request_tbl";
$newRequestResult = $conn->query($newRequestSql);

if ($newRequestResult->num_rows > 0) {
    while ($newRow = $newRequestResult->fetch_assoc()) {
        $newRequest = $newRow['details'];

        // Preprocess the new request
        $newRequest = $tfIdfTransformer->transform([$newRequest]);

        // Make prediction
        $prediction = $classifier->predict($newRequest);

        echo "Prediction: " . $prediction[0] . "\n";
    }
}

// Close the database connection
$conn->close();
?>