<!DOCTYPE html>
<html>
<head>
    <title>Speech-to-Text Conversion</title>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script>
     $(document).ready(function() {
    
    // Check browser support for the Web Speech API
    if ('webkitSpeechRecognition' in window) {
        var recognition = new webkitSpeechRecognition();
        
        // Set recognition options
        recognition.continuous = true; // Keep listening for speech until stopped
        recognition.interimResults = true; // Get interim results as the user speaks
        
        // Handle recognition result
        recognition.onresult = function(event) {
            var result = event.results[event.results.length - 1][0].transcript;
            $('#result').text(result);
            if(result.toLowerCase() === "\u0635\u062F\u0627\u0645"){
                alert("Match found!");
                window.location.href = '<?php echo "employees_ulv.php";?>';
            }else{
                alert();
            }
        
        };
        
        // Handle recognition error
        recognition.onerror = function(event) {
            console.error('Recognition error:', event.error);
        };
        
        // Start the speech recognition process
        $('#startButton').click(function() {
            recognition.start();
        });
    } else {
        console.error('Web Speech API is not supported in this browser.');
    }
});
    </script>
</head>
<body>
    <h1>Speech-to-Text Conversion</h1>
    <button id="startButton">Start Recording</button>
    <div id="result"></div>
</body>
</html>